IF EXISTS ( SELECT 1 FROM SYS.procedures WHERE NAME LIKE 'P_ATUALIZA_STS_EST_PROD_TBL_DESC') 
	DROP PROCEDURE P_ATUALIZA_STS_EST_PROD_TBL_DESC
GO

CREATE PROCEDURE [dbo].[P_ATUALIZA_STS_EST_PROD_TBL_DESC] AS
--------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MUDANDO O STATUS DAS TABELAS PENDENDES ON FINALIZADAS(PRORROGADAS) PARA ATIVO
--------------------------------------------------------------------------------------------------------------------------------------------------------------------
UPDATE
	t
SET
	t.STS_TBL_DESC = 1
FROM
	EST_PROD_TBL_DESC t
WHERE
	NOT t.DT_FIM = '1900-01-01'--(EXCLUI DA PESQUISA TABLELAS QUE NÃO TEM DATA VALIDADE)
	AND t.DT_INI <= CONVERT(DATE, GETDATE(), 112)
	AND STS_TBL_DESC = 0

--------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MUDANDO O STATUS DAS TABELAS VENCIDAS PARA FINALIZADO
--------------------------------------------------------------------------------------------------------------------------------------------------------------------
UPDATE
	t
SET
	t.STS_TBL_DESC = 2
FROM
	EST_PROD_TBL_DESC t
WHERE
	NOT t.DT_FIM = '1900-01-01'--(EXCLUI DA PESQUISA TABLELAS QUE NÃO TEM DATA DE VALIDADE)
	AND t.DT_FIM < CONVERT(DATE, GETDATE(), 112)
	AND STS_TBL_DESC = 1

--------------------------------------------------------------------------------------------------------------------------------------
--MUDANDO O STATUS DE DESCONTO DE CARGOS 
--------------------------------------------------------------------------------------------------------------------------------------
UPDATE
   T
 SET
   T.STS_TBL = 1
 FROM 
	EST_PROD_TBL_DESC_CARGO T
 WHERE
  T.STS_TBL = 0 
  
--------------------------------------------------------------------------------------------------------------------------------------
--MUDANDO O STATUS DE DESCONTO DE QUANTIDADE PARA ATIVO
--------------------------------------------------------------------------------------------------------------------------------------
UPDATE
	T
 SET
	T.STS_TBL_DESC = 1
 FROM 
	EST_PROD_TBL_DESC_QTDE T
 WHERE
	NOT T.DT_FIM = '1900-01-01'--(EXCLUI DA PESQUISA TABLELAS QUE NÃO TEM DATA DE VALIDADE)
	AND T.DT_INI <= CONVERT(DATE, GETDATE(), 112)
	AND T.STS_TBL_DESC = 0 
  
  
--------------------------------------------------------------------------------------------------------------------------------------
--MUDANDO O STATUS DE DESCONTO DE QUANTIDADE PARA INATIVO
--------------------------------------------------------------------------------------------------------------------------------------
  UPDATE
	t
SET
	t.STS_TBL_DESC = 2
FROM
	EST_PROD_TBL_DESC_QTDE t
WHERE
	NOT T.DT_FIM = '1900-01-01'--(EXCLUI DA PESQUISA TABLELAS QUE NÃO TEM DATA DE VALIDADE)
	AND T.DT_FIM < CONVERT(DATE, GETDATE(), 112)
	AND STS_TBL_DESC = 1
